void Printfloat(float a)
{
   Serial.print((int)a);
   int fraction = ((a - (int)a) * 100.0);
   Serial.print(".");
   Serial.print(fraction);
}

// This function is executed at power up   
void setup()
{
  Serial.begin(38400);    // configure the serial port to 38400 baud
  pinMode(8,OUTPUT);      // configure the port with the LED
  digitalWrite(8,HIGH);   // Turn off the LED
}

void loop()
{
  int pressure;
  int temperature;
  float voltage;
  float kpa;
  float celcius;
  

  pressure = analogRead(0);                      // read analog port 0 with the pressure sensor
  temperature = analogRead(1);                   // read analog port 1 with the temperature sensor
  voltage = (float)pressure / 1023.0 * 5.0;      // calculate the voltage of the pressure sensor
  kpa = 22.222 * voltage + 10.566;               // calculate the pressure in KPa
  voltage = (float)temperature / 1023.0 * 5.0;   // calculate the voltage of the temp. sensor
  celcius = voltage * 50.0 + 4.5;                // calculate the temperature in Celcius
  Serial.print("S");                             // send transmit command to transmitter
  Printfloat(kpa);                               // print the pressure sensor value
  Serial.print(" ");                             // insert a space
  Printfloat(celcius);                           // print the temperature
  Serial.println(" ");                           // insert space and terminate
  digitalWrite(8,LOW);                           // turn on LED
  delay(500);                                    // wait 500 milliseconds
  digitalWrite(8,HIGH);                          // turn off LED
  delay(500);                                    // wait 500 milliseconds  
}
